<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LAPA_Capabilities {

    public static function init() {
        add_filter( 'user_has_cap', [ __CLASS__, 'filter_caps' ], 10, 3 );
    }

    public static function filter_caps( $allcaps, $caps, $args ) {
        if ( lapa_is_current_user_allowed() ) return $allcaps;

        $uri = isset( $_SERVER['REQUEST_URI'] ) ? wp_unslash( $_SERVER['REQUEST_URI'] ) : '';
        if ( strpos( $uri, 'nav-menus.php' ) !== false ) {
            $allcaps['edit_theme_options'] = true;
        }

        $block_caps = [ 'edit_themes', 'activate_plugins', 'install_plugins', 'edit_plugins', 'customize', 'switch_themes' ];
        foreach ( $block_caps as $cap ) {
            $allcaps[ $cap ] = false;
        }

        return $allcaps;
    }
}
