<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LAPA_Menu_Restrictor {

    public static function init() {
        add_action( 'admin_menu', [ __CLASS__, 'restrict_menus' ], 999 );
        add_action( 'admin_menu', [ __CLASS__, 'remove_extra_menus' ], 9999 );
    }

    public static function restrict_menus() {
        if ( lapa_is_current_user_allowed() ) return;

        remove_menu_page( 'plugins.php' );
        remove_menu_page( 'themes.php' );
        remove_menu_page( 'customize.php' );
        remove_menu_page( 'widgets.php' );

        add_menu_page(
            __( 'فهرست‌ها', LAPA_TEXT_DOMAIN ),
            __( 'فهرست‌ها', LAPA_TEXT_DOMAIN ),
            'read',
            'nav-menus.php',
            '',
            'dashicons-admin-appearance',
            60
        );
        add_submenu_page( 'nav-menus.php', __( 'فهرست‌ها', LAPA_TEXT_DOMAIN ), __( 'فهرست‌ها', LAPA_TEXT_DOMAIN ), 'read', 'nav-menus.php' );
    }

    public static function remove_extra_menus() {
        if ( lapa_is_current_user_allowed() ) return;
        remove_menu_page( 'elementor' );
        remove_menu_page( 'elementor-system-info' );
        remove_menu_page( 'theme-settings' );
        remove_menu_page( 'site-settings' );
    }
}
