<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LAPA_Page_Blocker {

    public static function init() {
        add_action( 'admin_init', [ __CLASS__, 'block_pages' ] );
    }

    public static function block_pages() {
        if ( lapa_is_current_user_allowed() ) return;

        global $pagenow;

        $blocked_pages = [
            'themes.php',
            'customize.php',
            'widgets.php',
            'plugin-install.php',
            'plugin-editor.php',
            'plugins.php'
        ];

        if ( in_array( $pagenow, $blocked_pages, true ) ) {
            wp_safe_redirect( admin_url() );
            exit;
        }

        if ( isset( $_GET['page'] ) ) {
            $page = sanitize_text_field( wp_unslash( $_GET['page'] ) );
            $blocked = [ 'starter', 'hello-theme', 'theme-settings', 'elementor', 'site-settings', 'customize', 'widgets', 'options' ];
            foreach ( $blocked as $b ) {
                if ( stripos( $page, $b ) !== false && $page !== 'nav-menus.php' ) {
                    wp_safe_redirect( admin_url() );
                    exit;
                }
            }
        }
    }
}
