<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LAPA_Settings_Page {

    const NONCE_ACTION = 'lapa_save_action';
    const NONCE_NAME   = 'lapa_nonce';

    public static function init() {
        add_action( 'admin_menu', [ __CLASS__, 'add_settings_page' ] );
    }

    public static function add_settings_page() {
        if ( ! current_user_can( 'manage_options' ) ) return;
        if ( ! lapa_is_current_user_allowed() ) return;

        add_options_page(
            __( 'تنظیمات محدودسازی منو', LAPA_TEXT_DOMAIN ),
            __( 'محدودسازی کاربران', LAPA_TEXT_DOMAIN ),
            'manage_options',
            'lapa-settings',
            [ __CLASS__, 'render_page' ]
        );
    }

    public static function render_page() {
        if ( ! current_user_can( 'manage_options' ) ) wp_die( __( 'دسترسی غیرمجاز', LAPA_TEXT_DOMAIN ) );

        $current_allowed = lapa_get_allowed_user_id();

        if ( isset( $_POST['lapa_save'] ) ) {
            if ( ! isset( $_POST[ self::NONCE_NAME ] ) || ! wp_verify_nonce( wp_unslash( $_POST[ self::NONCE_NAME ] ), self::NONCE_ACTION ) ) {
                echo '<div class="error"><p>' . esc_html__( 'خطای امنیتی: nonce نامعتبر.', LAPA_TEXT_DOMAIN ) . '</p></div>';
            } else {
                if ( $current_allowed === 0 || get_current_user_id() === $current_allowed ) {
                    $new = isset( $_POST['lapa_user'] ) ? intval( wp_unslash( $_POST['lapa_user'] ) ) : 0;
                    if ( $new === 0 || user_can( $new, 'manage_options' ) ) {
                        update_option( LAPA_OPTION_NAME, $new );
                        echo '<div class="updated"><p>✅ ' . esc_html__( 'تنظیمات ذخیره شد.', LAPA_TEXT_DOMAIN ) . '</p></div>';
                    } else {
                        echo '<div class="error"><p>⛔ ' . esc_html__( 'کاربر انتخاب‌شده مدیر نیست.', LAPA_TEXT_DOMAIN ) . '</p></div>';
                    }
                } else {
                    echo '<div class="error"><p>⛔ ' . esc_html__( 'شما اجازه تغییر این تنظیم را ندارید.', LAPA_TEXT_DOMAIN ) . '</p></div>';
                }
            }
        }

        $admins = get_users( [
            'role__in' => [ 'administrator' ],
            'fields'   => [ 'ID', 'display_name', 'user_login' ],
            'orderby'  => 'display_name',
        ] );

        ?>
        <div class="wrap">
            <h1><?php esc_html_e( 'تنظیمات محدودسازی منوها', LAPA_TEXT_DOMAIN ); ?></h1>
            <form method="post">
                <?php wp_nonce_field( self::NONCE_ACTION, self::NONCE_NAME ); ?>
                <table class="form-table">
                    <tr>
                        <th><label for="lapa_user"><?php esc_html_e( 'انتخاب مدیر مجاز', LAPA_TEXT_DOMAIN ); ?></label></th>
                        <td>
                            <select name="lapa_user" id="lapa_user">
                                <option value="0"><?php esc_html_e( 'هیچ‌کس', LAPA_TEXT_DOMAIN ); ?></option>
                                <?php foreach ( $admins as $admin ): ?>
                                    <option value="<?php echo esc_attr( $admin->ID ); ?>" <?php selected( $current_allowed, $admin->ID ); ?>>
                                        <?php echo esc_html( $admin->display_name . ' (' . $admin->user_login . ')' ); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <p class="description"><?php esc_html_e( 'فقط این کاربر می‌تواند منوی افزونه‌ها و سایر آیتم‌های نمایش را ببیند. فهرست‌ها برای همه کاربران باز است.', LAPA_TEXT_DOMAIN ); ?></p>
                        </td>
                    </tr>
                </table>
                <p><input type="submit" name="lapa_save" class="button button-primary" value="<?php esc_attr_e( 'ذخیره', LAPA_TEXT_DOMAIN ); ?>"></p>
            </form>
        </div>
        <?php
    }
}
